/*
  Top 10, a racing simulator
  Copyright (C) 2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "FogValues.hh"

namespace top10
{
  namespace ui_interactive
  {

    FogValues::FogValues():
      m_density(0.0),
      m_near(0.0),
      m_far(0.0),
      m_col_r(0),
      m_col_g(0),
      m_col_b(0)
    {
    }



    FogValues FogValues::createClear()
    {
      FogValues ret;

      ret.m_density = 0.01;
      ret.m_near = 10.0;
      ret.m_far = 1e4;
      ret.m_col_r = 128;
      ret.m_col_g = 128;
      ret.m_col_b = 128;

      return ret;
    }



    FogValues FogValues::createRainy()
    {
      FogValues ret;

      ret.m_density = 0.35;
      ret.m_near = 5.0;
      ret.m_far = 150.0;
      ret.m_col_r = 128;
      ret.m_col_g = 128;
      ret.m_col_b = 128;

      return ret;
    }



  }
}
