/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "FileMenu.hh"
#include "UIPanel.hh"
#include "util/PathFinder.hh"
#include <plib/ul.h>

using namespace top10::ui_interactive;

void FileMenu::selected()
{
  assert(notifier);
  
  if (getNumEntries() > 0)
    notifier->entrySelected(getMenuText(getEntryN()), entry_types[getEntryN()]);
  panel->hide();
}

static bool isOfExtension(std::string filename, std::string ext)
{
  int s = filename.size();
  int s2 = ext.size();

  if (s <= s2) return false;

  return filename.substr(s-s2, s2) == ext;
}

void FileMenu::buildFileList(EntryType accepted)
{
  std::string dirpath = top10::util::PathFinder::defaultPathFinder().find(path);
  if (dirpath.empty()) throw std::string("Could not find directory: ")+path;

  ulDir* uldir = ulOpenDir(dirpath.c_str());
  if (!uldir) throw std::string("Could not open directory: ")+dirpath;

  ulDirEnt* dirent = ulReadDir(uldir);
  while (dirent) {
    std::string name = dirent->d_name;
    if (name != "." && name != "..") {
      if (dirent->d_isdir && (accepted & Dir)) {
	unsigned int id = addMenu(0);
        setMenuText(id, name);
        entry_types.push_back(Dir);
      }
      else if (accepted & File) {
        if (isOfExtension(name, extension)) {
	  unsigned int id = addMenu(0);
          setMenuText(id, name);
          entry_types.push_back(File);
        }
      }
    }
    dirent = ulReadDir(uldir);
  }
  ulCloseDir(uldir);

  updateNode();
}
