/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef FAKEKART_HH
#define FAKEKART_HH

#include "math/Vertex.hh"
#include "math/Matrix.hh"
#include "racing/LapRecord.hh"
#include "Kart.hh"

namespace top10 {
  namespace ui_interactive {
    //! Used to draw a kart whose physics have already been computed.
    /*! Used to represent remote karts in a net game, or a recorded lap
      when racing against one-self
    */
    class FakeKart {
    public:
      FakeKart(KartNode*);
      FakeKart();

      inline void setPos(top10::math::Vector v) {
	pos = v;
      }

      inline void setOrient(const top10::math::Matrix3& M) {
	orient = M;
      }

      void setAngle(double angle) {
	steer_angle = angle;
      }

      inline void setState(top10::racing::KartState s0,
			   top10::racing::KartState s1, unsigned int ts) {
	assert(s0.timestamp <= ts && ts <= s1.timestamp);
	double f0 = ts - s0.timestamp;
	double f1 = s1.timestamp - ts;
	double ff = f1 + f0;
	f0 /= ff;
	f1 /= ff;
	top10::math::Vector p = f0*s0.translation + f1*s1.translation;
	setPos(p);
	setOrient(s0.orient);
	setAngle(f0*s0.steer + f1*s1.steer);
      }

    private:
      top10::math::Matrix3 orient;
      top10::math::Vector pos;
      double steer_angle;
    };
  };
};

#endif
