/*
  Top10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef _TOP10_ENGINE_SOUND_HH
#define _TOP10_ENGINE_SOUND_HH

#include <AL/al.h>
#include "util/RefCount.hh"
#include "math/Vertex.hh"

namespace top10
{
namespace sound
{
  class EngineRpmRange
  {
  public:
    EngineRpmRange(ALuint, double, double, double, double);
    ALuint getBuffer() const;
    double getRpmMin() const;
    double getRpmStart() const;
    double getRpmEnd() const;
    double getRpmMax() const;

  private:
    ALuint al_buffer;
    double rpm_min;
    double rpm_start;
    double rpm_end;
    double rpm_max;
  };

  class EngineSound: public top10::util::RefCount
  {
  public:
    static EngineRpmRange loadData(const char* filename, double, double, double, double);

  public:
    EngineSound();

    void insertRangeOn(EngineRpmRange);
    void insertRangeOff(EngineRpmRange);

    std::vector<ALuint> getBuffersOn() const;
    std::vector<ALuint> getBuffersOff() const;

    void getSourceParameters(double rpm, bool on_load, std::vector<double>& amplitudes, std::vector<double>& pitches) const;

  private:
    static double getPitch(double rpm, double rpm_min, double rpm_max);

    std::vector<EngineRpmRange> ranges_on;
    std::vector<EngineRpmRange> ranges_off;
  };

  class EngineSoundInstance: public top10::util::RefCount
  {
  public:
    EngineSoundInstance(const EngineSound*);
    ~EngineSoundInstance();

    void update(double rpm, bool on_load, const top10::math::Vector& pos, const top10::math::Vector& speed);

  private:
    top10::util::Ref<const EngineSound> model;
    std::vector<ALuint> al_sources_off;
    std::vector<ALuint> al_sources_on;
    bool error_reported;

  private:
    // Disable copying
    EngineSoundInstance(const EngineSoundInstance&);
    EngineSoundInstance& operator=(const EngineSoundInstance&);
  };

  EngineSound* buildKartSound();
};
};
#endif
