/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "DebugMenu.hh"

using namespace top10::ui_interactive;
using top10::util::Debug;

void DebugMenu::selected()
{
  if (getEntryN() < 0 || (unsigned int)getEntryN() >= debugs.size()) return;

  bool state = debugs[getEntryN()]->toggleDebug();
  std::string new_name = debugs[getEntryN()]->getName();
  if (state) new_name += " X";
  setMenuText(getEntryN(), new_name);
}

void DebugMenu::buildList()
{
  for (std::set<const Debug*>::const_iterator it = Debug::members.begin();
       it != Debug::members.end();
       ++it) {
    std::string new_name = (*it)->getName();
    if ((*it)->is_debug()) new_name += " X";
    unsigned int id = addMenu(0);
    setMenuText(id, new_name);
    debugs.push_back(*it);
  }    

  updateNode();
}
