/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UI_CONTROL_HH
#define TOP10_UI_CONTROL_HH

#include <cassert>
#include <SDL/SDL.h>
#include <list>
#include <iostream>
#include "racing/Action.hh"

namespace top10 {
  namespace ui_interactive {

    using top10::racing::Action;

    class Control {
    public:
      //! Uninitialized
      Control() {}
      Control(SDL_Event e): event(e) {}

      bool matchEvent(SDL_Event e) const;
      //! Similar to matchEvent, but return true if e corresponds to a button/key release
      bool invertedEvent(SDL_Event e) const;
      bool operator<(Control) const;
      bool operator==(Control other) const;
      
      void output(std::ostream& out) const;

      static bool accepted(SDL_Event);
      //! Extract the "value" of an event
      static Sint16 getValue(SDL_Event);

      inline SDL_Event getEvent() const { return event; }

    private:
      SDL_Event event;
    };

    class ActionMapping {
    public:
      typedef std::list<std::pair<Control, Action> >::const_iterator const_iterator;
      typedef std::list<std::pair<Control, Action> >::iterator iterator;

      ActionMapping();

      const_iterator find(SDL_Event) const;
      const_iterator find(Control) const;

      inline const_iterator begin() const { return l.begin(); }
      inline iterator begin() { return l.begin(); }

      inline const_iterator end() const { return l.end(); }
      inline iterator end() { return l.end(); }

      void insert(Control, Action);

    private:
      std::list<std::pair<Control, Action> > l;
    };

    std::istream& operator>>(std::istream&, Control&);
    inline std::ostream& operator<<(std::ostream& out, Control ctrl) {
      ctrl.output(out);
      return out;
    }

    ActionMapping loadActionMapping(std::string filename);
    void saveActionMapping(std::string filename, ActionMapping digs);
  };
};
#endif
