#ifndef WALL_DIALOG_HH
#define WALL_DIALOG_HH

#include "qt/ComboBoxEdit.hh"
#include "qt/ListPick.hh"
#include "util/NoCopy.hh"
#include "trackedit/UpdateClient.hh"
#include "trackedit/WallEditor.hh"
#include "WallPropertiesSkel.hh"
#include "TextureWidget.hh"
#include <QtGui/QDialog>
#include <QtGui/QTabWidget>

class WallDialog: public QDialog, public top10::tracked::UpdateClient, public top10::util::NoCopy
{
  Q_OBJECT

public:
  WallDialog(QWidget* parent =0);
  ~WallDialog();

  void setEditor(top10::tracked::WallEditor*);

  void updateDialog();

  void updateUi();

private:
  void updateNames();
  void updatePoints();
  void updateProps();
  void updateTexture();

  void updateImage();

private slots:
  void on_m_wall_names_itemCreated(const QString&);
  void on_m_wall_names_itemDeleted(const QString&);
  void on_m_wall_names_itemSelected(const QString&); 
  void on_m_wall_names_itemRenamed(const QString&);

  void on_m_points_list_itemIncluded(int pos, const QString&);
  void on_m_points_list_itemExcluded(int pos, const QString&);

  void on_m_props_height_returnPressed();
  void on_m_props_thickness_returnPressed();
  void on_m_props_slant_returnPressed();
  void on_m_props_wall_toggled(bool);
  void on_m_props_mesh_toggled(bool);

  void on_Texture_lineEdit_editingFinished();
  void on_ScaleLat_lineEdit_editingFinished();
  void on_ScaleLong_lineEdit_editingFinished();
  void on_TranslateLat_lineEdit_editingFinished();
  void on_TranslateLong_lineEdit_editingFinished();
  void on_FileSelect_pushButton_pressed();

private:
  top10::tracked::WallEditor* m_editor;

  top10::qt::ComboBoxEdit* m_wall_names;
  top10::qt::ListPickWidget* m_points_list;
  Ui::WallPropertiesSkel m_props_skel;
  QWidget* m_props;
  TextureWidget* m_texture;
  QWidget* m_tab1;
  QWidget* m_tab2;
  QTabWidget* m_tabs;

  static const char* WALL_LABEL;
  static const char* MESH_LABEL;
};

#endif
