/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef VALUE_EDITOR_DLG_HH
#define VALUE_EDITOR_DLG_HH

#include "ValueEditorDlgSkel.hh"

#include <QtGui/QDialog>
#include <QtGui/QTableWidget>

#include "util/ValueHandle.hh"

class ValueEditorDlg: public QDialog, public Ui::ValueEditorDlgSkel
{
  Q_OBJECT

public:
  ValueEditorDlg(QWidget* parent=0);

  //! Add a new ValueHandle
  /*! The handle must not have been previously added.
      The ValueEditorDlg takes ownership of the ValueHandle.
      */
  void addValueHandle(top10::util::ValueHandle*);

  ~ValueEditorDlg();

public slots:
  void on_tableWidget_cellClicked(int row, int column);
  void on_tableWidget_cellChanged(int row, int column);

private:
  std::vector<top10::util::ValueHandle*> values;
};

#endif
