/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "ValueEditorDlg.hh"

ValueEditorDlg::ValueEditorDlg(QWidget* parent)
: QDialog(parent)
{
  setupUi(this);
  tableWidget->setColumnCount(2);
}

void ValueEditorDlg::addValueHandle(top10::util::ValueHandle* v)
{
  values.push_back(v);

  tableWidget->setRowCount(tableWidget->rowCount() +1);

  QTableWidgetItem* new_widget = new QTableWidgetItem;
  new_widget->setText(v->getName().c_str());
  new_widget->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled); // Not editable
  tableWidget->setItem(values.size() -1, 0, new_widget);

  new_widget = new QTableWidgetItem;
  new_widget->setText(v->getValueAsText().c_str());
  new_widget->setToolTip(v->getDefaultValueAsText().c_str());
  tableWidget->setItem(values.size() -1, 1, new_widget);
}

ValueEditorDlg::~ValueEditorDlg()
{
  while (tableWidget->rowCount() > 0)
  {
    tableWidget->removeRow(0);
  }

  for (std::vector<top10::util::ValueHandle*>::iterator it = values.begin();
    it != values.end();
    ++it)
  {
    delete *it;
  }
}

void ValueEditorDlg::on_tableWidget_cellClicked(int row, int column)
{
  top10::util::ValueHandle* handle = values.at(row);
  textBrowser->setPlainText(handle->getDescription().c_str());
}

void ValueEditorDlg::on_tableWidget_cellChanged(int row, int column)
{
  if (column != 1)
    return;

  top10::util::ValueHandle* handle = values.at(row);
  handle->setValueAsText(tableWidget->item(row, column)->text().toStdString());
  tableWidget->item(row, column)->setText(handle->getValueAsText().c_str());
}
