/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TRIANGULATIONDLG_HH
#define TRIANGULATIONDLG_HH

#include "TriangulationDlgSkel.hh"
#include "../TriangulationEditor.hh"
#include "TextureWidget.hh"
#include <QtGui/QtGui>

class TriangulationDlg: public QWidget, public Ui::TriangulationDlgSkel
{
  Q_OBJECT
      
public:
  TriangulationDlg();
  ~TriangulationDlg();

  inline void setEditor(top10::tracked::TriangulationEditor* _ed) { ed = _ed; }
  
  void update();
  
public slots:
  void on_maxAngle_lineEdit_textEdited( const QString& );
  void on_minDistance_lineEdit_textEdited( const QString& );
  void on_GrassDist_lineEdit_editingFinished();

  void _on_Grass_ScaleLat_editingFinished();
  void _on_Grass_ScaleLong_editingFinished();
  void _on_Grass_TranslateLat_editingFinished();
  void _on_Grass_TranslateLong_editingFinished();
  void _on_Grass_Filename_editingFinished();
  void _on_Grass_FileSelect_pressed();

  void _on_Side_ScaleLat_editingFinished();
  void _on_Side_ScaleLong_editingFinished();
  void _on_Side_TranslateLat_editingFinished();
  void _on_Side_TranslateLong_editingFinished();
  void _on_Side_Filename_editingFinished();
  void _on_Side_FileSelect_pressed();

  void updateImage();

private:
  top10::tracked::TriangulationEditor* ed;

  //! Texture of the ground
  TextureWidget grass_texture;
  //! Texture of the ground near the road
  TextureWidget side_texture;
};

#endif
