/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#include "TriangulationDlg.hh"

TriangulationDlg::TriangulationDlg()
  : ed(0)
{
  setupUi(this);

  Textures_tabWidget->removeTab(0);
  Textures_tabWidget->addTab(&grass_texture, "Grass");
  Textures_tabWidget->addTab(&side_texture, "Road side");

  connect(grass_texture.Texture_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Grass_Filename_editingFinished()));
  connect(grass_texture.ScaleLat_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Grass_ScaleLat_editingFinished()));
  connect(grass_texture.ScaleLong_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Grass_ScaleLong_editingFinished()));
  connect(grass_texture.TranslateLat_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Grass_TranslateLat_editingFinished()));
  connect(grass_texture.TranslateLong_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Grass_TranslateLong_editingFinished()));
  connect(grass_texture.FileSelect_pushButton, SIGNAL(pressed()), this, SLOT(_on_Grass_FileSelect_pressed()));

  connect(side_texture.Texture_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Side_Filename_editingFinished()));
  connect(side_texture.ScaleLat_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Side_ScaleLat_editingFinished()));
  connect(side_texture.ScaleLong_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Side_ScaleLong_editingFinished()));
  connect(side_texture.TranslateLat_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Side_TranslateLat_editingFinished()));
  connect(side_texture.TranslateLong_lineEdit, SIGNAL(editingFinished()), this, SLOT(_on_Side_TranslateLong_editingFinished()));
  connect(side_texture.FileSelect_pushButton, SIGNAL(pressed()), this, SLOT(_on_Side_FileSelect_pressed()));

}

TriangulationDlg::~TriangulationDlg()
{
}

void TriangulationDlg::update()
{
  maxAngle_lineEdit->setText(QString().setNum(ed->getMaxAngle()));
  minDistance_lineEdit->setText(QString().setNum(ed->getMinDistance()));
  GrassDist_lineEdit->setText(QString().setNum(ed->getGrassDistance()));
  grass_texture.init(*ed->getGrassTexture());
  side_texture.init(*ed->getSideTexture());
}

void TriangulationDlg::on_maxAngle_lineEdit_textEdited( const QString& txt )
{
  bool ok;
  double val = txt.toDouble(&ok);
  if (ok) ed->setMaxAngle(val);
}

void TriangulationDlg::on_minDistance_lineEdit_textEdited( const QString& txt )
{
  bool ok;
  double val = txt.toDouble(&ok);
  if (ok) ed->setMinDistance(val);
}

void TriangulationDlg::on_GrassDist_lineEdit_editingFinished()
{
  bool ok;
  double val = GrassDist_lineEdit->text().toDouble(&ok);
  if (ok) ed->setGrassDistance(val);
}

//
// Grass texture
//

void TriangulationDlg::_on_Grass_Filename_editingFinished( )
{
  assert(ed);
  ed->setGrassTexture(grass_texture.Texture_lineEdit->text().toStdString());
  updateImage();
}

void TriangulationDlg::_on_Grass_ScaleLat_editingFinished( )
{
  assert(ed);
  ed->setGrassTextureScaleLat(grass_texture.ScaleLat_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Grass_ScaleLong_editingFinished( )
{
  assert(ed);
  ed->setGrassTextureScaleLong(grass_texture.ScaleLong_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Grass_TranslateLat_editingFinished( )
{
  assert(ed);
  ed->setGrassTextureTranslateLat(grass_texture.TranslateLat_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Grass_TranslateLong_editingFinished( )
{
  assert(ed);
  ed->setGrassTextureTranslateLong(grass_texture.TranslateLong_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Grass_FileSelect_pressed( )
{
  assert(ed);
  
  // Open the file selector
  QString s = QFileDialog::getOpenFileName(this, tr("Choose a file to open"), "./", tr("Texture (*.tga *.jpg *.png)"));
  if (s.isEmpty()) return;
  
  grass_texture.Texture_lineEdit->setText(s);
  
  std::string name = s.toStdString();
  ed->setGrassTexture(name);
  
  updateImage();
}


//
// Side texture
//

void TriangulationDlg::_on_Side_Filename_editingFinished( )
{
  assert(ed);
  ed->setSideTexture(side_texture.Texture_lineEdit->text().toStdString());
  updateImage();
}

void TriangulationDlg::_on_Side_ScaleLat_editingFinished( )
{
  assert(ed);
  ed->setSideTextureScaleLat(side_texture.ScaleLat_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Side_ScaleLong_editingFinished( )
{
  assert(ed);
  ed->setSideTextureScaleLong(side_texture.ScaleLong_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Side_TranslateLat_editingFinished( )
{
  assert(ed);
  ed->setSideTextureTranslateLat(side_texture.TranslateLat_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Side_TranslateLong_editingFinished( )
{
  assert(ed);
  ed->setSideTextureTranslateLong(side_texture.TranslateLong_lineEdit->text().toFloat());
  updateImage();
}

void TriangulationDlg::_on_Side_FileSelect_pressed( )
{
  assert(ed);
  
  // Open the file selector
  QString s = QFileDialog::getOpenFileName(this, tr("Choose a file to open"), "./", tr("Texture (*.tga *.jpg *.png)"));
  if (s.isEmpty()) return;
  
  side_texture.Texture_lineEdit->setText(s);
  
  std::string name = s.toStdString();
  ed->setSideTexture(name);
  
  updateImage();
}

void TriangulationDlg::updateImage()
{
  if (grass_texture.Texture_lineEdit->text().isEmpty())
    grass_texture.erase();
  else
    grass_texture.loadFile(grass_texture.Texture_lineEdit->text());

  if (side_texture.Texture_lineEdit->text().isEmpty())
    side_texture.erase();
  else
    side_texture.loadFile(side_texture.Texture_lineEdit->text());

  QWidget::update();
}
