/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "TextureWidget.hh"

TextureWidget::TextureWidget(QWidget* parent):
  QWidget(parent)
{
  setupUi(this);
  texture_layout = new QGridLayout(View_frame);
  texture_layout->addWidget(&image, 0, 0);
}

TextureWidget::~TextureWidget()
{
  delete texture_layout;
}

void TextureWidget::loadFile(const QString& f)
{
  image.loadFile(f);
}

void TextureWidget::showImage(const QImage& i)
{
  image.showImage(i);
}

void TextureWidget::erase()
{
  image.erase();
}

void TextureWidget::init(top10::track::TextureSpec s)
{
  if (!s.getFilename().empty())
    image.loadFile(s.getFilename().c_str());
  else
    erase();

  Texture_lineEdit->setText(s.getFilename().c_str());
  ScaleLat_lineEdit->setText(QString().setNum(s.getScaleLat()));
  ScaleLong_lineEdit->setText(QString().setNum(s.getScaleLong()));
  TranslateLat_lineEdit->setText(QString().setNum(s.getTranslateLat()));
  TranslateLong_lineEdit->setText(QString().setNum(s.getTranslateLong()));
}
