/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TEXTURES_DLG_HH
#define TEXTURES_DLG_HH

#include "TextureDlgSkel.hh"
#include "../TexturesEditor.hh"
#include <QtGui/QDialog>
#include "ImageView.hh"

class TextureDlg: public QDialog, public Ui::TextureDlgSkel
{
  Q_OBJECT
      
public:
  TextureDlg();
  ~TextureDlg();
  
  void setEditor(top10::tracked::TexturesEditor*);
  void update();
    
public slots:
  void on_FS_pushButton_pressed();
  void on_Remove_pushButton_pressed();
  void on_Textures_comboBox_currentIndexChanged(const QString&);
  
private:
  top10::tracked::TexturesEditor* ed;
  QGridLayout* image_layout;
  ImageView image;
};

#endif
