/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "TextureDlg.hh"
#include "util/Log.hh"
#include <QtGui/QFileDialog>
#include <QtGui/QImage>
#include <QtGui/QPainter>

using top10::util::Log;

TextureDlg::TextureDlg():
  ed(0)
{
  setupUi(this);
  image_layout = new QGridLayout(Image_frame);
  image_layout->addWidget(&image, 0, 0);
}

TextureDlg::~TextureDlg()
{
  delete image_layout;
}

void TextureDlg::setEditor(top10::tracked::TexturesEditor* _ed)
{
  ed = _ed;
}

void TextureDlg::on_FS_pushButton_pressed()
{
  // Open the file selector
  QString s = QFileDialog::getOpenFileName(this, tr("Choose a file to open", "./"), tr("Texture (*.tga *.jpg *.png)"));
  if (s.isEmpty()) return;
  
  std::string name = s.toStdString();
  if (Textures_comboBox->currentIndex() == 0)
  {
    // Add new texture
    int ok = ed->addTexture(name);
    if (ok == 0)
    {
      // Update the combobox: add the texture att the end
      int pos = Textures_comboBox->count();
      Textures_comboBox->insertItem(pos, QString(name.c_str()));
      Textures_comboBox->setCurrentIndex(pos);
      Log::getSingle()->send(Log::Info, "TextureDlg", "Added texture "+name);          
    }
    else
    {
      Log::getSingle()->send(Log::Error, "TextureDlg", "Could not add texture "+name+", maybe because it already exists");          
    }
  }
  else
  {
    int pos = Textures_comboBox->currentIndex();
    std::string current_name = Textures_comboBox->currentText().toStdString();
    int ok = ed->addTexture(name);
    if (ok == 0)
    {
      // Update the combobox: replace the current entry
      ed->removeTexture(current_name);
      Textures_comboBox->removeItem(pos);
      Textures_comboBox->insertItem(pos, QString(name.c_str()));
      Textures_comboBox->setCurrentIndex(pos);
      Log::getSingle()->send(Log::Info, "TextureDlg", "Replaced texture "+current_name+" by "+name);
    }
    else
    {
     Log::getSingle()->send(Log::Error, "TextureDlg", "Could not change this texture to "+name+", maybe because it already exists");   
    }
  }
  
  QDialog::update();
}

void TextureDlg::update()
{
  Textures_comboBox->clear();
  std::list<std::string> textures = ed->getTextures();
  int pos = 0;
  Textures_comboBox->insertItem(0, tr("New texture"));
  ++pos;
  for (std::list<std::string>::const_iterator it = textures.begin(); it != textures.end(); ++it, ++pos)
  {
    Textures_comboBox->insertItem(pos, QString(it->c_str()));   
  }
  Textures_comboBox->setCurrentIndex(0);
}

void TextureDlg::on_Remove_pushButton_pressed()
{
  if (Textures_comboBox->currentIndex() == 0) return;
  
  std::string name = Textures_comboBox->currentText().toStdString();
  
  int ok = ed->removeTexture(name);
  if (ok == 0)
    Log::getSingle()->send(Log::Info, "TextureDlg", "Removed texture "+name);
  else
    Log::getSingle()->send(Log::Critical, "TextureDlg", "Could not remove texture "+name);
  
  // Update combo box
  Textures_comboBox->removeItem(Textures_comboBox->currentIndex());
}

void TextureDlg::on_Textures_comboBox_currentIndexChanged(const QString& filename)
{
  if (Textures_comboBox->currentIndex() == 0 || filename.isEmpty())
    image.erase();
  else
    image.loadFile(filename);
  
  QDialog::update();
}
