/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef STATUSBARRECEIVER_HH
#define STATUSBARRECEIVER_HH

#include "util/Log.hh"

class QStatusBar;
class QTextEdit;

//! Display messages from the log to a status bar
class StatusBarReceiver: public top10::util::Log::Receiver {
public:
  StatusBarReceiver();

  void setStatusBar(QStatusBar*);
  QStatusBar* getStatusBar() const;
  
  void setLogWindow(QTextEdit*);
  QTextEdit* getLogWindow() const;

  void receive(top10::util::Log::Level, std::string origin, std::string msg);

private:
  void receiveStatus(top10::util::Log::Level, std::string origin, std::string msg);
  void receiveLogText(top10::util::Log::Level, std::string origin, std::string msg);

  QStatusBar* status_bar;
  QTextEdit* log_window;
};

#endif
