/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <QtGui/QTextEdit>
#include <QtGui/QStatusBar>
#include <QtGui/QTextCursor>

#include "StatusBarReceiver.hh"

StatusBarReceiver::StatusBarReceiver():
  status_bar(0),
  log_window(0)
{
}

void StatusBarReceiver::setStatusBar(QStatusBar* s)
{
  status_bar = s;
}

QStatusBar* StatusBarReceiver::getStatusBar() const
{
  return status_bar;
}

void StatusBarReceiver::setLogWindow(QTextEdit* ed)
{
  log_window = ed;
}

QTextEdit* StatusBarReceiver::getLogWindow() const
{
  return log_window;
}

void StatusBarReceiver::receive(top10::util::Log::Level lv, std::string origin, std::string m)
{
  receiveStatus(lv, origin, m);
  receiveLogText(lv, origin, m);
}


void StatusBarReceiver::receiveLogText(top10::util::Log::Level lv, std::string origin, std::string m)
{
  if (!log_window) return;
  
  QString msg;
  switch (lv) {
    case top10::util::Log::Critical: msg = "CRITICAL: "; break;
    case top10::util::Log::Error: msg = "ERROR: "; break;
    case top10::util::Log::Info: msg = "INFO: "; break;
    case top10::util::Log::Warning: msg = "WARNING: "; break;
    case top10::util::Log::Debug: msg = "DEBUG: "; break;
  }
  msg = msg + "(" + origin.c_str() + ") " + m.c_str() + "\n";
  
  QTextCursor cursor = log_window->textCursor();
  cursor.movePosition(QTextCursor::End);
  log_window->setTextCursor(cursor);
  log_window->insertPlainText(msg);
}

void StatusBarReceiver::receiveStatus(top10::util::Log::Level lv, std::string origin, std::string m)
{
  if (!status_bar) return;
  
  QString msg;
  switch (lv) {
    case top10::util::Log::Info: msg = "INFO: "; break;
    default: return;
  }
  msg = msg + m.c_str();
  
  status_bar->showMessage(msg);
}


