/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef SECTIONSDLG_HH
#define SECTIONSDLG_HH

#include "SectionsDlgSkel.hh"
#include "QGLView.hh"
#include "../SectionsEditor.hh"
#include "TextureWidget.hh"

class SectionsDlg: public QDialog, public Ui::SectionsDlgSkel
{
  Q_OBJECT
      
public:
  SectionsDlg();

  inline void setEditor(top10::tracked::SectionsEditor* p) { ed = p; }
  inline void setViewer(QGLView* p) { viewer = p; }

  //! Set all widgets to reflect the editor's state
  void fullUpdate();
  inline void update() { fullUpdate(); }
  
  inline std::string getOrigin() const { return "SectionsDlg"; }

protected:
  virtual void showEvent(QShowEvent* e);

private slots:
  void on_Path_comboBox_editTextEdited(const QString&);
  void on_Path_comboBox_activated(const QString&);
  void on_PathDelete_pushButton_pressed();
  void on_PathAdd_pushButton_pressed();
  void on_PrevControl_Btn_pressed();
  void on_NextControl_Btn_pressed();
  void on_CurrentControl_lineEdit_editingFinished();
  void on_DeleteControl_Btn_pressed();
  void on_AddControl_Btn_pressed();
  void on_Loop_checkBox_stateChanged(int);
  void on_AutoTg_pushButton_pressed();

  void on_Waypoint_comboBox_activated(int);
  void on_Fetch_pushButton_pressed();
  
  void on_TgFactorIn_doubleSpinBox_valueChanged(double);
  void on_TgFactorOut_doubleSpinBox_valueChanged(double);
  void on_SecondaryTg_checkBox_stateChanged(int);

  void on_LRoadWidth_doubleSpinBox_valueChanged(double);
//   void on_LKerb_comboBox_activated(int);
//   void on_LKerbWidth_doubleSpinBox_valueChanged(double);
//   void on_LKerbHeight_doubleSpinBox_valueChanged(double);

  void on_RRoadWidth_doubleSpinBox_valueChanged(double);
//  void on_RKerb_comboBox_activated(int);
//  void on_RKerbWidth_doubleSpinBox_valueChanged(double);
//  void on_RKerbHeight_doubleSpinBox_valueChanged(double);

  void on_Texture_lineEdit_editingFinished();
  void on_ScaleLat_lineEdit_editingFinished();
  void on_ScaleLong_lineEdit_editingFinished();
  void on_TranslateLat_lineEdit_editingFinished();
  void on_TranslateLong_lineEdit_editingFinished();
  void on_FileSelect_pushButton_pressed();
  
private:
  void updateImage();
  
private:
  top10::tracked::SectionsEditor* ed;
  QGLView* viewer;
  TextureWidget texture;
};

#endif
