/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_QGLVIEW_HH
#define TOP10_QGLVIEW_HH

#include "trackedit/Drawable.hh"
#include "trackedit/MainCamera.hh"
#include "util/RefCount.hh"
#include "graphX/MaterialNode.hh"
#include "graphX/GridNode.hh"
#include "graphX/LightNode.hh"
#include "graphX/SkyBoxNode.hh"
#include "graphX/AimMarkNode.hh"
#include "graphX/Renderer.hh"

#include <QtOpenGL/QtOpenGL>
#include <QtGui/QKeyEvent>

#include <plib/fnt.h>

class QGLView: public QGLWidget
{
public:
  QGLView(QWidget* parent=0, QGLWidget* shareWidget=0);
  ~QGLView();
  
  inline void setMainCamera(top10::tracked::MainCamera* c) { camera = c; }
  inline top10::graphX::CameraNode* getCamera() const { return camera; };
  void addDrawable(top10::tracked::Drawable* d);
  fntFont* getFont();

  float getPanSpeed() const;
  void setPanSpeed(float);

  float getFarDist() const;
  void setFarDist(float);

protected:
  void initializeGL();
  void resizeGL(int w, int h);
  void paintGL();

  void mouseMoveEvent(QMouseEvent*);
  //  void mousePressEvent(QMouseEvent*);
  void keyPressEvent(QKeyEvent*);

public:
  double pan_speed;

private:
  fntTexFont font;

  //! Used to keep track of mouse movements
  int old_x, old_y;
  const unsigned char hud_r, hud_g, hud_b;

  top10::tracked::MainCamera* camera;
  std::vector<top10::tracked::Drawable*> drawables;
  
  top10::util::Ref<top10::graphX::MaterialNode> top_node;
  top10::util::Ref<top10::graphX::MaterialNode> glowing;
  top10::util::Ref<top10::graphX::LightNode> light_node;
  top10::util::Ref<top10::graphX::SkyBoxNode> skybox;
  top10::util::Ref<top10::graphX::MaterialNode> hud_node;
  top10::util::Ref<top10::graphX::AimMarkNode> mark_node;
  
  top10::graphX::Renderer* renderer;
  
  QGLView(const QGLView&);
  QGLView& operator=(const QGLView&);
};

#endif
