/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#ifndef QGLMESHVIEW_HH
#define QGLMESHVIEW_HH

#include "helpers/MeshEditor.hh"
#include "graphX/GroupNode.hh"
#include "graphX/Renderer.hh"
#include "trackedit/MainCamera.hh"

#include <QtOpenGL/QtOpenGL>
#include <QtGui/QKeyEvent>

class QGLMeshView: public QGLWidget
{
public:
  //! Control whether mouse clicks affect the view or the model
  enum Mode { ModelView, ModelTranslateXZ, ModelTranslateXY, ModelRotateX, ModelRotateY, ModelRotateZ };
  
public:
  QGLMeshView(QWidget*, QGLWidget* shareWidget=0);
  ~QGLMeshView();
  
  void setMeshEditor(top10::helpers::MeshEditor*);

  void setMode(Mode);
  
protected:
  void initializeGL();
  void resizeGL(int w, int h);
  void paintGL();
  void mouseMoveEvent(QMouseEvent*);
  void keyPressEvent(QKeyEvent*);

private:
  top10::helpers::MeshEditor* mesh_ed;
  Mode mode;
  int old_x;
  int old_y;
  top10::graphX::Renderer* renderer;
  top10::util::Ref<top10::tracked::MainCamera> camera;
  top10::util::Ref<top10::graphX::GroupNode> top_node;
  
  static const unsigned char grid_r = 255;
  static const unsigned char grid_g = 255;
  static const unsigned char grid_b = 255;
  
  void makeTopNode();
  
  void modelView(QMouseEvent*);
  void modelView(QKeyEvent*);
  
  void modelTranslateXZ(QMouseEvent*);
  void modelTranslateXY(QMouseEvent*);
  void modelRotateX(QMouseEvent*);
  void modelRotateY(QMouseEvent*);
  void modelRotateZ(QMouseEvent*);
  
  // Forbidden
  QGLMeshView(const QGLMeshView&);
  QGLMeshView& operator=(const QGLMeshView&);
};

#endif
