/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef PATH_DLG_HH
#define PATH_DLG_HH

#include "PathDlgSkel.hh"
#include "QGLView.hh"
#include "../PathEditor.hh"

class PathDlg: public QDialog, public Ui::PathDlgSkel
{
  Q_OBJECT
      
public:
  PathDlg();
  inline void setEditor(top10::tracked::PathEditor* p) { ed = p; }
  inline void setViewer(QGLView* p) { viewer = p; }

  void update();
  
private slots:  
  void insertPoint();
  void deletePoint();
  void nextPoint();
  void prevPoint();
  void on_Current_lineEdit_editingFinished();
  void pickPoint();
  void setPoint();
  void setTangent();
  void rotateTangentCW();
  void rotateTangentCCW();
  void rotateTangentCW2();
  void rotateTangentCCW2();
  void setName();
  void on_BankAngle_doubleSpinBox_valueChanged(double);
    
private:
  QGLView* viewer;
  top10::tracked::PathEditor* ed;
  float rotation_step;
  
  //! To avoid calling slots while updating the dialog
  bool in_update;
};

#endif
