/*
  Top 10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

// This file should be named MyMainWindow. Oh well...

#ifndef MYMAINWIDOW_HH
#define MYMAINWIDOW_HH

#include <QtGui/QMainWindow>
#include <QtGui/QDockWidget>
#include <QtGui/QTextEdit>

#include "QGLView.hh"
#include "StartingAreaDlg.hh"
#include "CheckpointsDlg.hh"
#include "PathDlg.hh"
#include "SectionsDlg.hh"
#include "LayoutDlg.hh"
#include "HullDlg.hh"
#include "MeshLibDlg.hh"
#include "TriangulationDlg.hh"
#include "TextureDlg.hh"
#include "DistanceDlg.hh"
#include "StatusBarReceiver.hh"
#include "MeshInstanceDlg.hh"
#include "ValueEditorDlg.hh"
#include "ArcToolDlg.hh"
#include "WallDialog.hh"

#include "../MainEditor.hh"
#include "../CheckpointsEditor.hh"
#include "../StartingAreaEditor.hh"
#include "../PathEditor.hh"
#include "../SectionsEditor.hh"
#include "../LayoutEditor.hh"
#include "../HullEditor.hh"
#include "../TriangulationEditor.hh"
#include "helpers/MeshEditor.hh"
#include "../TexturesEditor.hh"
#include "../SectionsListener.hh"
#include "../MeshInstanceEditor.hh"
#include "../WallEditor.hh"

class QAction;
class QMenu;
class MyMainWindow;
class MyDockWidget;

class MyMainWindow: public QMainWindow
{
  Q_OBJECT
      
public:
  MyMainWindow();
  
protected:
  void closeEvent(QCloseEvent *event);

private slots:
  void newFile();
  void open();
  bool save();
  bool saveAs();
  void showPrefs();
  void about();
  void documentWasModified();
  
  // Show/hide in the main view
  void showCheckpointsView(bool);
  void showStartAreaView(bool);
  void showPathView(bool);
  void showSectionsView(bool);
  void showLayoutView(bool b);
  void showHullView(bool);
  void showTriangulationView(bool);
  void showMeshInstancesView(bool);
  void showWalls(bool);

  void updateOutline();
  
private:
  void createActions();
  void createMenus();
  void createToolBars();
  void createStatusBar();
  void readSettings();
  void writeSettings();
  bool maybeSave();
  void importFile(const QString& filename);
  void loadFile(const QString &fileName);
  bool saveFile(const QString &fileName);
  void setCurrentFile(const QString &fileName);
  QString strippedName(const QString &fullFileName);
  void updateDlgs();
  void updateEditors();
  void setOptionsDlg();

  QGLView *trackView;
  QTextEdit *logWindow;

  QMenu *fileMenu;
  QMenu *toolsMenu;
  QMenu *viewMenu;
  QMenu *helpMenu;
  QToolBar *fileToolBar;
  QToolBar *viewToolBar;
  QToolBar *editToolBar;
  QAction *newAct;
  QAction *openAct;
  QAction *saveAct;
  QAction *saveAsAct;
  QAction *optionsAct;
  QAction *exitAct;
  QAction *cutAct;
  QAction *copyAct;
  QAction *pasteAct;
  QAction *aboutAct;
  QAction *aboutQtAct;
  
  // Actions that can affect the main view
  QAction *showStartAreaAct;
  QAction *showCheckpointsAct;
  QAction *showPathAct;
  QAction *showSectionsAct;
  QAction *showLayoutAct;
  QAction *showHullAct;
  QAction *showTriangulationAct;
  QAction *updateOutlineAct;
  QAction *showMeshInstancesAct;
  QAction *showWallsAct;

  //! The name of the trk file
  std::string filename;

  top10::util::Ref<StatusBarReceiver> receiver;
  
  CheckpointsDlg  cps_dlg;
  StartingAreaDlg sa_dlg;
  PathDlg         path_dlg;
  SectionsDlg     sections_dlg;
  LayoutDlg       layout_dlg;
  HullDlg         hull_dlg;
  MeshLibDlg      *meshes_dlg;
  TriangulationDlg tri_dlg;
  TextureDlg      texture_dlg;
  DistanceDlg     dist_dlg;
  MeshInstanceDlg mesh_instance_dlg;
  ValueEditorDlg  options_dlg;
  ArcToolDlg      arc_tool_dlg;
  WallDialog      wall_dlg;

  std::list<QDockWidget*> docks;
  
  top10::tracked::MainEditor         main_ed;
  top10::tracked::CheckpointsEditor  cps_ed;
  top10::tracked::StartingAreaEditor sa_ed;
  top10::tracked::PathEditor         path_ed;
  top10::tracked::SectionsEditor     sections_ed;
  top10::tracked::LayoutEditor       layout_ed;
  top10::tracked::HullEditor         hull_ed;
  top10::tracked::TriangulationEditor tri_ed;
  top10::helpers::MeshEditor         meshes_ed;
  top10::tracked::TexturesEditor     texture_ed;
  top10::tracked::MeshInstanceEditor mesh_instance_ed;
  top10::tracked::WallEditor         wall_ed;

  top10::util::Ref<top10::tracked::MainCamera> camera;
  
  top10::util::Ref<top10::tracked::SectionsListener> sections_listener;
};

#endif
