/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#ifndef MESHLIBDLG_HH
#define MESHLIBDLG_HH

#include "helpers/MeshEditor.hh"
#include "MeshLibDlgSkel.hh"
#include "QGLMeshView.hh"

class MeshLibDlg: public QDialog, public Ui::MeshLibDlgSkel
{
  Q_OBJECT
      
public:
  MeshLibDlg(QGLWidget* share=0);

  void setEditor(top10::helpers::MeshEditor* ed);
  inline top10::helpers::MeshEditor* getEditor() { return mesh_ed; }
  
  void update();
  
  ~MeshLibDlg();
  
public slots:
  void _on_Name_comboBox_textEdited();
  void on_Name_comboBox_activated(const QString&);
  
  void on_M00_lineEdit_editingFinished();
  void on_M10_lineEdit_editingFinished();
  void on_M20_lineEdit_editingFinished();
  
  void on_M01_lineEdit_editingFinished();
  void on_M11_lineEdit_editingFinished();
  void on_M21_lineEdit_editingFinished();
  
  void on_M02_lineEdit_editingFinished();
  void on_M12_lineEdit_editingFinished();
  void on_M22_lineEdit_editingFinished();

  void on_M03_lineEdit_editingFinished();
  void on_M13_lineEdit_editingFinished();
  void on_M23_lineEdit_editingFinished();

  void on_Filename_lineEdit_editingFinished();
  
  void on_FS_pushButton_pressed();
  
  void on_View_radioButton_toggled(bool);
  void on_TranslateXZ_radioButton_toggled(bool);
  void on_TranslateXY_radioButton_toggled(bool);
  void on_RotateX_radioButton_toggled(bool);
  void on_RotateY_radioButton_toggled(bool);
  void on_RotateZ_radioButton_toggled(bool);

  void on_Add_pushButton_pressed();
  void on_Del_pushButton_pressed();

  void on_Show_front_CheckBox_stateChanged(int);
  void on_Show_back_CheckBox_stateChanged(int);
  void on_Shadow_CheckBox_stateChanged(int);
  void on_Collision_CheckBox_stateChanged(int);

private:
  friend class Listener;
  class Listener: public top10::helpers::MeshEditor::Listener
  {
  public:
    Listener(MeshLibDlg*);
    void notifyTransform(const top10::math::Matrix4&);
  private:
    MeshLibDlg* view;
  };

private:
  void transformEdited(int i, int j, const QString& text);
  void updateMatrix();
  void updateMeshName();
  void updateFileName();
  void updateProperties();
  void set3dsTransform();

  top10::helpers::MeshEditor* mesh_ed;
  QGLMeshView view;
  QCheckBox* Show_front_CheckBox;
  QCheckBox* Show_back_CheckBox;
  QCheckBox* Shadow_CheckBox;
  QCheckBox* Collision_CheckBox;
};

#endif
