/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef MESH_INSTANCE_DLG_HH
#define MESH_INSTANCE_DLG_HH

#include "trackedit/MeshInstanceEditor.hh"
#include "MeshInstanceDlgSkel.hh"
#include "QGLView.hh"

class MeshInstanceDlg: public QDialog, public Ui::MeshInstanceDlgSkel
{
  Q_OBJECT

public:
  MeshInstanceDlg();

  void setMeshInstanceEditor(top10::tracked::MeshInstanceEditor*);
  void setViewer(QGLView*);

  void update();

private slots:
  void on_Add_pushButton_pressed();
  void on_Del_pushButton_pressed();
  void on_Next_pushButton_pressed();
  void on_Prev_pushButton_pressed();
  void on_Pick_pushButton_pressed();
  void on_Angle_lineEdit_editingFinished();
  void on_Num_lineEdit_editingFinished();
  void on_X_lineEdit_editingFinished();
  void on_Y_lineEdit_editingFinished();
  void on_Z_lineEdit_editingFinished();
  void on_MeshName_comboBox_activated(const QString&);

private:
  top10::tracked::MeshInstanceEditor* ed;
  QGLView* view;
};

#endif
