/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "MeshInstanceDlg.hh"

MeshInstanceDlg::MeshInstanceDlg():
ed(0), view(0)
{
  setupUi(this);
}

void MeshInstanceDlg::setMeshInstanceEditor(top10::tracked::MeshInstanceEditor* _ed)
{
  ed = _ed;
}

void MeshInstanceDlg::setViewer(QGLView* v)
{
  view = v;
}

void MeshInstanceDlg::update()
{
  assert(ed);

  // The current mesh instance
  int idx = ed->getPos();
  if (idx == -1)
    Num_lineEdit->clear();
  else
    Num_lineEdit->setText(QString().setNum(idx));

  // The mesh names from the library
  MeshName_comboBox->clear();
  std::list<std::string> mesh_names = ed->getAllMeshNames();
  std::string mesh_name = ed->getMeshName();
  MeshName_comboBox->addItem("");
  MeshName_comboBox->setCurrentIndex(0);
  for (std::list<std::string>::const_iterator it = mesh_names.begin(); it != mesh_names.end(); ++it)
  {
    MeshName_comboBox->addItem(it->c_str());
    if (mesh_name == *it)
    {
      MeshName_comboBox->setCurrentIndex(MeshName_comboBox->count()-1);
    }
  }

  // Translation
  X_lineEdit->setText(QString().setNum(ed->getInstanceTranslation().x));
  Y_lineEdit->setText(QString().setNum(ed->getInstanceTranslation().y));
  Z_lineEdit->setText(QString().setNum(ed->getInstanceTranslation().z));

  // Rotation
  Angle_lineEdit->setText(QString().setNum(ed->getInstanceRotation()));
}

void MeshInstanceDlg::on_Angle_lineEdit_editingFinished()
{
  double value;
  bool ok = false;
  value = Angle_lineEdit->text().toDouble(&ok);
  if (ok)
    ed->setInstanceRotation(value);
  update();
}

void MeshInstanceDlg::on_Del_pushButton_pressed()
{
  ed->deleteInstance();
  update();
}

void MeshInstanceDlg::on_Add_pushButton_pressed()
{
  ed->addInstance();
  update();
}

void MeshInstanceDlg::on_MeshName_comboBox_activated(const QString& str)
{
  std::string tmp = str.toStdString();
  ed->setMeshName(tmp);
  update();
}

void MeshInstanceDlg::on_Next_pushButton_pressed()
{
  ed->gotoNext();
  update();
}

void MeshInstanceDlg::on_Prev_pushButton_pressed()
{
  ed->gotoPrev();
  update();
}

void MeshInstanceDlg::on_Num_lineEdit_editingFinished()
{
  int value;
  bool ok = false;
  value = Num_lineEdit->text().toInt(&ok);
  if (ok)
    ed->gotoInstance(value);
  update();
}

void MeshInstanceDlg::on_Pick_pushButton_pressed()
{
  top10::math::Vector dir = view->getCamera()->getView().getDirection();
  top10::math::Plane p(top10::math::Vector(0.0, 1.0, 0.0), 0.0);

  top10::math::Vector pos;
  double dist = 0.0;
  bool ok = intersectRay(p, view->getCamera()->getView().getCenter(), dir, pos, dist);
  if (ok)
    ed->setInstanceTranslation(pos);
  update();
}

void MeshInstanceDlg::on_X_lineEdit_editingFinished()
{
  double value;
  bool ok = false;
  value = X_lineEdit->text().toDouble(&ok);
  if (ok)
  {
    top10::math::Vector T = ed->getInstanceTranslation();
    T.x = value;
    ed->setInstanceTranslation(T);
  }
  update();
}

void MeshInstanceDlg::on_Y_lineEdit_editingFinished()
{
  double value;
  bool ok = false;
  value = Y_lineEdit->text().toDouble(&ok);
  if (ok)
  {
    top10::math::Vector T = ed->getInstanceTranslation();
    T.y = value;
    ed->setInstanceTranslation(T);
  }
  update();
}

void MeshInstanceDlg::on_Z_lineEdit_editingFinished()
{
  double value;
  bool ok = false;
  value = Z_lineEdit->text().toDouble(&ok);
  if (ok)
  {
    top10::math::Vector T = ed->getInstanceTranslation();
    T.z = value;
    ed->setInstanceTranslation(T);
  }
  update();
}
