/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "LayoutDlg.hh"


LayoutDlg::LayoutDlg(): ed(0), view(0)
{
  setupUi(this);
}

LayoutDlg::~LayoutDlg()
{
}

void LayoutDlg::update()
{
  assert(ed);
  QString tmp;
  
  Filename_lineEdit->setText(ed->getFilename().c_str());
  SizeX_lineEdit->setText(tmp.setNum(ed->getSizeX()));
  SizeZ_lineEdit->setText(tmp.setNum(ed->getSizeZ()));
  Altitude_lineEdit->setText(tmp.setNum(ed->getAltitude()));
  GridUnit_lineEdit->setText(tmp.setNum(ed->getGridUnit()));
}

void LayoutDlg::on_Filename_lineEdit_textEdited(const QString& fname)
{
  assert(ed);
  ed->setFilename(fname.toStdString());
  
  if (view) view->updateGL();
}

void LayoutDlg::on_SizeX_lineEdit_textEdited(const QString& s)
{
  assert(ed);
  ed->setSizeX(s.toDouble());
  
  if (view) view->updateGL();
}

void LayoutDlg::on_SizeZ_lineEdit_textEdited(const QString& s)
{
  assert(ed);
  ed->setSizeZ(s.toDouble());
  
  if (view) view->updateGL();  
}

void LayoutDlg::on_Altitude_lineEdit_textEdited(const QString& s)
{
  assert(ed);
  ed->setAltitude(s.toDouble());
  
  if (view) view->updateGL();
}

void LayoutDlg::on_GridUnit_lineEdit_textEdited(const QString& s)
{
  assert(ed);
  ed->setGridUnit(s.toDouble());
  
  if (view) view->updateGL();
}

void LayoutDlg::on_Open_pushButton_pressed()
{
  assert(ed);
  
  QString s = QFileDialog::getOpenFileName(this, "Choose a file to open", "./", "Textures (*.tga *.jpg *.jpeg *.png)");
  if (!s.isEmpty()) {
    Filename_lineEdit->setText(s);
    on_Filename_lineEdit_textEdited(s);
  }
}
