/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "ImageView.hh"
#include <QtGui/QPainter>
#include <QtGui/QPaintEvent>

ImageView::ImageView(QWidget* parent):
  QWidget(parent)
{
}

ImageView::~ImageView()
{
}

void ImageView::loadFile(const QString& filename)
{
  image.load(filename);
  if (image.isNull()) erase();
}

void ImageView::showImage(const QImage& im)
{
  image = im;
}

void ImageView::erase()
{
  image = QImage();
}

void ImageView::paintEvent(QPaintEvent *ev)
{
  QPainter painter(this);
  painter.fillRect(ev->rect(), QColor(0, 0, 0));
  painter.drawImage(0, 0, image);
}
