/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef HULLDLG_HH
#define HULLDLG_HH

#include "HullDlgSkel.hh"
#include "../HullEditor.hh"
#include <QtGui/QWidget>

class HullDlg: public QWidget, public Ui::HullDlgSkel
{
  Q_OBJECT
      
public:
  HullDlg();
  inline void setEditor(top10::tracked::HullEditor* _ed) { ed = _ed; }
  
  void update();
  
public slots:
  void on_AddHull_pushButton_pressed();
  void on_DelHull_pushButton_pressed();
  void on_HullName_comboBox_editTextChanged(const QString&);
  
  void on_Add_pushButton_pressed();
  void on_Del_pushButton_pressed();
  void on_Invert_checkBox_toggled(bool);
  void on_Vertex_list_currentRowChanged(int);
  
private:
  top10::tracked::HullEditor* ed;
};

#endif
