/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#include "HullDlg.hh"

HullDlg::HullDlg()
{
  setupUi(this);
}

void HullDlg::update()
{
  assert(ed);
  
  // HullNames_comboBox
  HullName_comboBox->clear();
  std::vector<std::string> hull_names = ed->getHullNames();
  int idx = 0;
  int current_idx = -1;
  for (std::vector<std::string>::const_iterator it = hull_names.begin();
       it != hull_names.end();
       ++it)
  {
    HullName_comboBox->addItem(it->c_str());
    if (*it == ed->getCurrentHullName()) current_idx = idx;
    ++idx;
  }
  if (idx != -1) HullName_comboBox->setCurrentIndex(current_idx);
  
  // Vertex_list
  Vertex_list->clear();
  Vertex_list->addItem("***");
  std::vector<std::string> vertex_names = ed->getCurrentVertexNames();
  for (std::vector<std::string>::const_iterator it = vertex_names.begin();
       it != vertex_names.end();
       ++it)
  {
    Vertex_list->addItem(it->c_str());
  }
  if (ed->getCurrentVertexIdx() != -1) Vertex_list->setCurrentRow(ed->getCurrentVertexIdx()+1);
  
  // Invert_checkBox
  Invert_checkBox->setChecked(ed->getInvert());
}

void HullDlg::on_AddHull_pushButton_pressed()
{
  assert(ed);
  ed->addHull();
  update();
}

void HullDlg::on_Add_pushButton_pressed()
{
  assert(ed);
  ed->addVertex();
  update();
}

void HullDlg::on_DelHull_pushButton_pressed()
{
  assert(ed);
  ed->removeHull();
  update();
}

void HullDlg::on_Del_pushButton_pressed()
{
  assert(ed);
  ed->removeVertex();
  update();
}

void HullDlg::on_HullName_comboBox_editTextChanged(const QString& new_name)
{
  assert(ed);
  if (!new_name.isEmpty())
    ed->renameHull(new_name.toStdString());
}

void HullDlg::on_Invert_checkBox_toggled(bool b)
{
  assert(ed);
  ed->setInvert(b);
}

void HullDlg::on_Vertex_list_currentRowChanged(int idx)
{
  assert(ed);
  ed->setCurrentVertex(idx==-1 ? idx : idx-1);
}
