/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef DISTANCE_DLG_HH
#define DISTANCE_DLG_HH

#include "DistanceDlgSkel.hh"
#include "../PathEditor.hh"

#include <QtGui/QDialog>

class DistanceDlg: public QDialog, public Ui::DistanceDlgSkel
{
  Q_OBJECT

public:
  DistanceDlg(QWidget* parent =0);
  
  void setEditor(top10::tracked::PathEditor*);

  void populate();
  void computeDist();

public slots:
  void on_WP1_comboBox_activated(const QString&);
  void on_WP2_comboBox_activated(const QString&);

private:
  top10::tracked::PathEditor* ed;
  std::string wp1_name;
  std::string wp2_name;

  friend class Listener;
  class Listener: public top10::tracked::PathEditor::Listener
  {
  public:
    Listener(DistanceDlg*);

    virtual void notifyAdd(const top10::tracked::PathEditor::WayPoint&);
    virtual void notifyRemove(top10::tracked::PathEditor::WayPoint);
    virtual void notifyMove(const top10::tracked::PathEditor::WayPoint&);
    virtual void notifyName(const top10::tracked::PathEditor::WayPoint&);

  private:
    DistanceDlg* dlg;
  };

};

#endif
