/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "DistanceDlg.hh"

DistanceDlg::DistanceDlg(QWidget* parent):
QDialog(parent),
ed(0)
{
  setupUi(this);
}

void DistanceDlg::setEditor(top10::tracked::PathEditor* e)
{
  ed = e;
  populate();
  ed->addListener(new Listener(this));
}

void DistanceDlg::populate()
{
  assert(ed);

  WP1_comboBox->clear();
  WP2_comboBox->clear();

  for (std::vector<top10::tracked::PathEditor::WayPoint>::const_iterator it = ed->waypoints.begin();
    it != ed->waypoints.end();
    ++it)
  {
    WP1_comboBox->addItem(QString(it->name.c_str()));
    WP2_comboBox->addItem(QString(it->name.c_str()));
  }
}

void DistanceDlg::computeDist()
{
  assert(ed);

  int idx1, idx2;
  idx1 = ed->findNamed(wp1_name);
  idx2 = ed->findNamed(wp2_name);

  if (idx1 >=0 && idx2 >= 0)
  {
    double dist = (ed->waypoints.at(idx1).pos - ed->waypoints.at(idx2).pos).size();
    Dist_label->setText(QString().setNum(dist));
  }
  else
  {
    Dist_label->setText("NA");
  }
}

void DistanceDlg::on_WP1_comboBox_activated(const QString& str)
{
  wp1_name = str.toStdString();
  computeDist();
}

void DistanceDlg::on_WP2_comboBox_activated(const QString& str)
{
  wp2_name = str.toStdString();
  computeDist();
}

DistanceDlg::Listener::Listener(DistanceDlg *dlg):
dlg(dlg)
{
}

void DistanceDlg::Listener::notifyAdd(const top10::tracked::PathEditor::WayPoint &)
{
  dlg->populate();
}

void DistanceDlg::Listener::notifyMove(const top10::tracked::PathEditor::WayPoint& wp)
{
  if (wp.name == dlg->wp1_name || wp.name == dlg->wp2_name)
    dlg->computeDist();
}

void DistanceDlg::Listener::notifyName(const top10::tracked::PathEditor::WayPoint &)
{
  dlg->populate();
}

void DistanceDlg::Listener::notifyRemove(top10::tracked::PathEditor::WayPoint)
{
  dlg->populate();
}

