/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef CHECKPOINTS_DLG_HH
#define CHECKPOINTS_DLG_HH

#include "CheckpointsDlgSkel.hh"
#include "../CheckpointsEditor.hh"
#include "QGLView.hh"

class CheckpointsDlg: public QDialog, public Ui::CheckpointsDlgSkel {
  Q_OBJECT
      
public:
  CheckpointsDlg();
  inline void setEditor(top10::tracked::CheckpointsEditor* p) { cps_ed = p; }
  inline void setViewer(QGLView* p) { viewer = p; }

  //! Read the info from the editor, and populate the various fields in the dialog
  void update();

private slots:  
  void nextCheckpoint();
  void prevCheckpoint();
  void delCheckpoint();
  void insertCheckpoint();
//  void setCheckpoint1();
//  void setCheckpoint2();
  void pickCheckpoint1();
  void pickCheckpoint2();

private:
  top10::tracked::CheckpointsEditor* cps_ed;
  QGLView* viewer;
};

#endif
