/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef ARCTOOL_DLG_HH
#define ARCTOOL_DLG_HH

#include "ArcToolDlgSkel.hh"
#include "trackedit/PathEditor.hh"
#include "util/NoCopy.hh"
#include <QtGui/QDialog>

class ArcToolDlg : public QDialog, public Ui::ArcToolDlgSkel, private top10::util::NoCopy
{
  Q_OBJECT

public:
  ArcToolDlg(QWidget* parent=0);
  void setWaypointsEditor(top10::tracked::PathEditor* ed);

  // Called by the listener.
  void newWaypoint(const top10::tracked::PathEditor::WayPoint&);
  void delWaypoint(const top10::tracked::PathEditor::WayPoint);
  void renameWaypoint(const top10::tracked::PathEditor::WayPoint&);

  ~ArcToolDlg();

public slots:
  void on_Add_pushButton_pressed();
  void on_Remove_pushButton_pressed();
  void on_OK_pushButton_pressed();

private:

  //! Used to rebuild the lists of waypoints when a waypoint is added, removed or renamed.
  class Listener: public top10::tracked::PathEditor::Listener {
  public:
    Listener(ArcToolDlg*);
    virtual void notifyAdd(const top10::tracked::PathEditor::WayPoint&);
    virtual void notifyRemove(top10::tracked::PathEditor::WayPoint);
    virtual void notifyName(const top10::tracked::PathEditor::WayPoint&);
  private:
    ArcToolDlg* tool;
  };

  top10::tracked::PathEditor* path_ed;
  Listener* listener;

private:
  void moveWaypoints(double radius, double x, double z);
  bool computeCenter(double radius, double& x, double& z);
};

#endif
