/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <cstdlib>

#include "SurfacesDialog.hh"
#include "DialogManager.hh"
#include "topListBox.hh"

#define LISTBOX_H0 (2*Dialog::H)
#define LISTBOX_H1 (7*Dialog::H)
#define LISTBOX_W  400

/*
 * Callbacks
 */

static void pick_cb(puObject* ob)
{
  SurfacesDialog* dialog = (SurfacesDialog*)ob->getUserData();
  dialog->getManager()->surf_ed->pick();
  dialog->getManager()->surf_ed->add();

  dialog->remove();
  dialog->install();
  dialog->show();
}

static void types_cb(puObject* ob)
{
  SurfacesDialog* dialog = (SurfacesDialog*)ob->getUserData();
  char *tmp;
  ob->getValue(&tmp);
  int idx;
  for (idx=0; top10::tracked::surfaceTypeNames[idx] &&
	 std::string(tmp) != std::string(top10::tracked::surfaceTypeNames[idx]); ++idx);
  dialog->getManager()->surf_ed->setCurrentSurfaceType(top10::tracked::toSurfaceTypeEnum(idx));

  dialog->remove();
  dialog->install();
  dialog->show();
}

/*
 * Class implementation
 */
SurfacesDialog::SurfacesDialog(DialogManager* manager):
  Dialog(manager, "Surfaces")
{
}

void SurfacesDialog::populate()
{
  puOneShot* pick = new puOneShot(0, H, LISTBOX_W, 2*H);
  pick->setLegend("Pick");
  pick->setUserData(this);
  pick->setCallback(pick_cb);

  if (!getManager()->surf_ed->getCurrentSurfaceSet().empty()) {
    textures = new topListBox(0, LISTBOX_H0, LISTBOX_W, LISTBOX_H1, getManager()->surf_ed->getCurrentSurfaceSet());
  }

  puComboBox* types_combo = new puComboBox(0, LISTBOX_H1, LISTBOX_W, LISTBOX_H1+H,
					   const_cast<char**>(top10::tracked::surfaceTypeNames), 0);
  types_combo->setUserData(this);
  types_combo->setCallback(types_cb);
  types_combo->setValue(top10::tracked::surfaceTypeNames[getManager()->surf_ed->getCurrentSurfaceType()]);
}
