/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <plib/puAux.h>
#include <cassert>

#include "MeshDialog.hh"
#include "DialogManager.hh"


static char *axes_txt[] = {"+X", "+Y", "+Z", "-X", "-Y", "-Z", 0};

// Mesh name was edited manually
static void name_cb(puObject* ob)
{
  MeshDialog* dialog = (MeshDialog*)ob->getUserData();
  char *str;
  ob->getValue(&str);
  try {
    dialog->getManager()->mesh_ed->loadMesh(str);
  }
  catch(std::string e) {
    std::cerr<<"Error: "<<e<<std::endl;
  }
}

/*
 * Callback spaghetti for choosing a mesh file using a fileselector
 */

// Fileselector is closing
static void fs_done_cb(puObject* ob)
{
  char* str;
  ob->getValue(&str);

  // close the file selector and go back to mesh dialog
  MeshDialog* dialog = (MeshDialog*)ob->getUserData();
  puDeleteObject(ob);
  dialog->install();
  dialog->show();

  // Actually do the load
  if (str[0]) {
    dialog->getManager()->mesh_ed->loadMesh(str);
  }
}

// Show a fileselector
static void fs_cb(puObject* ob)
{
  MeshDialog* dialog = (MeshDialog*)ob->getUserData();
  dialog->remove();
  puaFileSelector* fs = new puaFileSelector(0,0,300,400, ".");
  fs->setUserData(dialog);
  fs->setCallback(fs_done_cb);
  fs->reveal();
}

/*
 * Axes callback
 */
static void axes_cb(puObject* ob)
{
  MeshDialog* dialog = (MeshDialog*)ob->getUserData();
  char *str;
  ob->getValue(&str);
  std::string axis_str(str);

  if (axis_str[0] == '-')
    dialog->getManager()->mesh_ed->setAxisNegate(true);
  else if (axis_str[0] == '+')
    dialog->getManager()->mesh_ed->setAxisNegate(false);
  else assert(0);

  if (axis_str[1] == 'X')
    dialog->getManager()->mesh_ed->setAxis(top10::math::X);
  else if (axis_str[1] == 'Y')
    dialog->getManager()->mesh_ed->setAxis(top10::math::Y);
  else if (axis_str[1] == 'Z')
    dialog->getManager()->mesh_ed->setAxis(top10::math::Z);
  else assert(0);
}

// Scale callback
static void scale_cb(puObject* ob)
{
  MeshDialog* dialog = (MeshDialog*)ob->getUserData();
  float s;
  ob->getValue(&s);
  dialog->getManager()->mesh_ed->setScaling(s);
}

MeshDialog::MeshDialog(DialogManager* dm):
  Dialog(dm, "Track mesh")
{
}

void MeshDialog::populate()
{
  puOneShot* fs = new puOneShot(0, H, S_W, 2*H);
  fs->setLegend("FS");
  fs->setUserData(this);
  fs->setCallback(fs_cb);

  puInput* mesh_filename = new puInput(S_W, H, S_W+XL_W, 2*H);
  mesh_filename->setLabel("Mesh file");
  mesh_filename->setUserData(this);
  mesh_filename->setCallback(name_cb);
  mesh_filename->setValue(getManager()->mesh_ed->getFilename().c_str());

  puComboBox* axes = new puComboBox(0, 2*H, L_W, 3*H, axes_txt, 0);
  axes->setUserData(this);
  axes->setCallback(axes_cb);
  std::string ax;
  if (getManager()->mesh_ed->getAxisNegate()) ax = "-";
  else ax = "+";
  switch (getManager()->mesh_ed->getAxis()) {
  case top10::math::X: ax += "X"; break;
  case top10::math::Y: ax += "Y"; break;
  case top10::math::Z: ax += "Z"; break;
  }
  axes->setValue(ax.c_str());

  puInput* scaling = new puInput(0, 3*H, M_W, 4*H);
  scaling->setLabel("Scaling");
  scaling->setUserData(this);
  scaling->setCallback(scale_cb);
  scaling->setValue(getManager()->mesh_ed->getScaling());
}
