/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <plib/puAux.h>

#include "FileMenuDialog.hh"
#include "DialogManager.hh"

static void load_cb(puObject* ob)
{
  ((FileMenuDialog*)ob->getUserData())->load();
}

static void save_cb(puObject* ob)
{
  ((FileMenuDialog*)ob->getUserData())->save();
}

static void saveAs_cb(puObject* ob)
{
  ((FileMenuDialog*)ob->getUserData())->saveAs();
}

FileMenuDialog::FileMenuDialog(DialogManager* dm):
  Dialog(dm, "File")
{
}

void FileMenuDialog::populate()
{
  puOneShot* load = new puOneShot(0, 3*H, M_W, 4*H);
  load->setLegend("Load");
  load->setUserData(this);
  load->setCallback(load_cb);

  puOneShot* save = new puOneShot(0, 2*H, M_W, 3*H);
  save->setLegend("Save");
  save->setUserData(this);
  save->setCallback(save_cb);

  puOneShot* save_as = new puOneShot(0, H, M_W, 2*H);
  save_as->setLegend("Save As");
  save_as->setUserData(this);
  save_as->setCallback(saveAs_cb);
}

static void fs_load_cb(puObject* ob)
{
  char* ptr;
  ob->getValue(&ptr);
  std::string filename = ptr;

  // close the file selector and go back to the file menu
  FileMenuDialog* dialog = (FileMenuDialog*)ob->getUserData();
  puDeleteObject(ob);
  dialog->install();
  dialog->show();

  // Actually do the load, now
  if (!filename.empty()) {
    dialog->getManager()->main_ed->loadTrack(filename);
    dialog->setFilename(filename);
  }
}

void FileMenuDialog::load()
{
  remove();
  puaFileSelector* fs = new puaFileSelector(0,0,300,400, ".");
  fs->setUserData(this);
  fs->setCallback(fs_load_cb);
  fs->reveal();
}

static void fs_save_cb(puObject* ob)
{
  char* ptr;
  ob->getValue(&ptr);
  std::string filename = ptr;

  // close the file selector and go back to the file menu
  FileMenuDialog* dialog = (FileMenuDialog*)ob->getUserData();
  puDeleteObject(ob);
  dialog->install();
  dialog->show();

  // Actually do the save, now
  if (!filename.empty()) {
    dialog->setFilename(filename);
    dialog->save();
  }
}

void FileMenuDialog::save()
{
  getManager()->main_ed->saveTrack(filename);
}

void FileMenuDialog::saveAs()
{
  remove();
  puaFileSelector* fs = new puaFileSelector(0,0,300,400, ".");
  fs->setUserData(this);
  fs->setCallback(fs_save_cb);
  fs->reveal();
}
