/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Camera.hh"
#include <cassert>

void Camera::handleEvent(SDL_Event event)
{
  using top10::math::Vector;

  if (event.type == SDL_MOUSEMOTION) {
    // Rotate the camera
    if (event.motion.state & SDL_BUTTON(3)) {
      if (old_x >= 0) {
	double f_x = 180.0/width;
	double f_y = 90.0/height;

	rotateY((event.motion.x - old_x)*f_x);
	rotateX((event.motion.y - old_y)*f_y);
	update();
      }
    }
    // Move the camera (pan)
    else if (event.motion.state & SDL_BUTTON(1)) {
      if (old_x >= 0) {
	double f_x = 50.0/width;
	double f_y = 50.0/height;

	Vector flat_dir = getView().getDirection();
	flat_dir.y = 0.0;
	double s = flat_dir.size();
	if (s > SMALL_VECTOR)
	  flat_dir /= s;
	else {
	  flat_dir = getView().getUp();
	  flat_dir.y = 0;
	  s = flat_dir.size();
	  assert(s > SMALL_VECTOR);
	  flat_dir /= s;
	}
	translate((event.motion.x-old_x)*f_x*getView().getRight() - (event.motion.y-old_y)*f_y*flat_dir);
	update();
      }
    }
    else if (event.motion.state & SDL_BUTTON(2)) {
      if (old_x >= 0) {
	double f_y = 50.0/height;
	translate(Vector(0.0, (event.motion.y - old_y) * f_y, 0.0));
	update();
      }
    }

    old_x = event.motion.x;
    old_y = event.motion.y;
  }
  else if (event.type == SDL_KEYDOWN) {
   if (event.key.keysym.sym == SDLK_KP_PLUS) {
     zoom(1.1);
   }
   else if (event.key.keysym.sym == SDLK_KP_MINUS) {
     zoom(1.0/1.1);
   }
  }
}
