#ifndef TOP10_WALL_EDITOR_HH
#define TOP10_WALL_EDITOR_HH

#include "PathEditor.hh"
#include "UpdateClient.hh"
#include "math/Vec2D.hh"
#include "track/TextureSpec.hh"

namespace top10
{
  namespace tracked
  {
    class WallEditor: public Drawable
    {
    public:
      static const char* NODE_NAME;

    public:
      WallEditor();

      void setPathEditor(PathEditor*);

      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;
      
      std::string getOrigin() const;

      std::string newWall();
      bool renameWall(const std::string&);
      bool deleteWall();
      bool setCurrentWall(const std::string&);
      void setTypeWall();
      void setTypeMesh();
      void getWallNames(std::list< std::string >*) const;
      std::string getWallName() const;
      void getAllPointNames(std::list< std::string >*) const;

      bool insertPoint(int pos, const std::string&);
      bool removePoint(const std::string&);
      bool setHeight(double);
      bool setThickness(double);
      bool setSlant(double);

      bool isTypeWall() const;
      bool isTypeMesh() const;
      std::string getName() const;
      double getHeight() const;
      double getThickness() const;
      double getSlant() const;
      void getPointNames(std::list< std::string >*);

      top10::track::TextureSpec* getTexture();

      top10::graphX::GroupNode* generate(bool mark_current) const;

    private:

      struct Wall
      {
	enum Type { WALL, MESH };

	std::string m_name;
	double m_height;
	double m_thickness;
	double m_slant;
	std::vector<int> m_wp_ids;
	Type m_type;
	top10::track::TextureSpec m_texture;
      };

      void updateNode();
      top10::graphX::GroupNode* generateWall(const Wall&) const;

      static void generateWallShape(const Wall& wall, std::vector< top10::math::Vec2D >*);

    private:
      class Listener: public PathEditor::Listener
      {
      public:
	Listener(WallEditor* ed);
	virtual void notifyRemove(top10::tracked::PathEditor::WayPoint);
	virtual void notifyMove(const top10::tracked::PathEditor::WayPoint&);

      private:
	WallEditor* m_editor;
      };
      friend class Listener;

    private:
      top10::util::Ref<Listener> m_listener;

      PathEditor* m_path_editor;

      std::vector< Wall > m_walls;

      int m_current;

      top10::util::Ref< top10::graphX::Node > m_node;

      static const int WALL_TYPE;
      static const int MESH_TYPE;
    };
  }
}

#endif
