#ifndef TOP10_TRACKED_UPDATE_CLIENT_HH
#define TOP10_TRACKED_UPDATE_CLIENT_HH

namespace top10
{
  namespace tracked
  {
    //! Callback class used to notify GUI elements they should update themselves.
    /*!
      Used when data in an editor is changed and requires a GUI element to be updated.
      */
    class UpdateClient
    {
    public:
      virtual void updateUi() =0;
      virtual ~UpdateClient() {}
    };

    class UpdateServer
    {
    public:
      UpdateServer(): m_client(0) {}

      inline void setClient(UpdateClient* cl) { m_client = cl; }
      inline void freeClient() { m_client = 0; }
      
    protected:
      inline void callClient() { if (m_client) m_client->updateUi(); }

    private:
      UpdateClient* m_client;
    };
  }
} 

#endif
