/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#ifndef TOP10_TRACKEDTRIANGULATIONEDITOR_HH
#define TOP10_TRACKEDTRIANGULATIONEDITOR_HH

#include "Drawable.hh"
#include "SectionsEditor.hh"
#include "track/TextureSpec.hh"

namespace top10 {
namespace tracked {

//! Controls the looks of triangulation of the track
class TriangulationEditor : public top10::tracked::Drawable
{
public:
  TriangulationEditor();

  void setSectionsEditor(SectionsEditor*);
  void updateView();
  
  // Implementation of Drawable
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement* node) const;
  void clearState();
  std::string getOrigin() const;
  
  void setMaxAngle(double degrees);
  void setMinDistance(double dist);
  void setGrassDistance(double dist);

  double getMaxAngle() const;
  double getMinDistance() const;
  double getGrassDistance() const;

  void setGrassTexture(std::string);
  void setGrassTextureScaleLat(float);
  void setGrassTextureScaleLong(float);
  void setGrassTextureTranslateLat(float);
  void setGrassTextureTranslateLong(float);

  void setSideTexture(std::string);
  void setSideTextureScaleLat(float);
  void setSideTextureScaleLong(float);
  void setSideTextureTranslateLat(float);
  void setSideTextureTranslateLong(float);

  inline const top10::track::TextureSpec* getGrassTexture() const { return &grass_texture; }
  inline const top10::track::TextureSpec* getSideTexture() const { return &side_texture; }

private:
  SectionsEditor* sections_ed;
  top10::track::TextureSpec grass_texture;
  top10::track::TextureSpec side_texture;
  double max_angle;
  double min_dist;
  double grass_distance;
  
  top10::util::Ref<top10::graphX::MaterialNode> ground_mat;
  top10::util::Ref<top10::graphX::MaterialNode> error_mat;
};

}
}

#endif
