/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_TRACKEDSECTIONSLISTENER_HH
#define TOP10_TRACKEDSECTIONSLISTENER_HH

#include "PathEditor.hh"
#include "SectionsEditor.hh"

namespace top10 {
namespace tracked {

class SectionsListener: public PathEditor::Listener {
public:
  SectionsListener(SectionsEditor* ed): ed(ed), auto_add(false) {}
  
  void notifyAdd(const PathEditor::WayPoint&);
  void notifyRemove(PathEditor::WayPoint);
  void notifyMove(const PathEditor::WayPoint&);
  void notifyTangent(const PathEditor::WayPoint&);
  void notifyBanking(const PathEditor::WayPoint&);
  
  void setAutoAdd(bool b) { auto_add = b; }
  
private:
  SectionsEditor* ed;
  //! If true, notifyAdd will also add the new point to the current section
  bool auto_add;
};

}
}

#endif
