/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#ifndef TOP10_TRACKEDMESHINSTANCEEDITOR_HH
#define TOP10_TRACKEDMESHINSTANCEEDITOR_HH

#include "Drawable.hh"
#include "helpers/MeshEditor.hh"
#include "graphX/TransformNode.hh"
#include "graphX/MeshMarker.hh"

namespace top10 {
namespace tracked {

class MeshInstanceEditor: public Drawable
{
public:
  struct Item
  {
    top10::util::Ref< top10::graphX::Node > m_node;
    bool m_collides;
  };

public:
  MeshInstanceEditor();
  
  void setMeshEditor(top10::helpers::MeshEditor*);
  inline top10::helpers::MeshEditor* getMeshEditor() { return mesh_lib_ed; }

  top10::graphX::Node* getAllNodes() const;
  std::vector<Item> getItems() const;

  /*
   * Editor interface
   */
  void gotoInstance(int idx);
  void gotoNext();
  void gotoPrev();
  void addInstance();
  void deleteInstance();
  
  void setMeshName(std::string);
  void setInstanceTranslation(const top10::math::Vector&);
  void setInstanceRotation(double);
  
  std::list<std::string> getAllMeshNames() const;
  std::string getMeshName() const;
  int getMeshId() const;
  int getPos() const;
  top10::math::Vector getInstanceTranslation() const;
  double getInstanceRotation() const;
  top10::math::Matrix4 getInstanceTransform() const;

private:
  /*
   * XmlDumpable interface
   */
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement*) const;
  std::string getOrigin() const;
  void clearState();

  //! Set the current mesh_node according to mesh_id
  void setMeshNode();

  //! Update the marker showing the current instance
  void updateMarker();

private:
  top10::helpers::MeshEditor* mesh_lib_ed;
  
  struct MeshInstance {
    //! Refers to a mesh in the MeshEditor
    int mesh_id;
    //! Translation
    top10::math::Vector translation;
    //! Rotation around Y, in degrees
    double rotation;

    top10::util::Ref<top10::graphX::TransformNode> transform_node;
    top10::util::Ref<top10::graphX::Node> mesh_node;
  };

  typedef std::list< MeshInstance > InstanceList;
  
  InstanceList instances;
  InstanceList::iterator current_inst;

  top10::util::Ref<top10::graphX::MeshMarker> marker_node;
};

}
}

#endif
