/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_TRACKEDLAYOUTEDITOR_HH
#define TOP10_TRACKEDLAYOUTEDITOR_HH

#include "Drawable.hh"
#include "graphX/GridNode.hh"
#include "graphX/PanelNode.hh"
#include "graphX/TransformNode.hh"
#include "graphX/TextureNode.hh"
#include "graphX/MaterialNode.hh"

namespace top10 {
namespace tracked {

//! Shows a grid with a picture underneath
/*! The picture would be a sky view of the a real track. */
class LayoutEditor : public top10::tracked::Drawable
{
public:
  LayoutEditor();

  void setFilename(std::string);
  std::string getFilename() const;
  
  void setSizeX(float);
  float getSizeX() const;

  void setSizeZ(float);
  float getSizeZ() const;
  
  void setAltitude(float);
  float getAltitude() const;

  void setGridUnit(float);
  float getGridUnit() const;
  
  std::string getOrigin() const;
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement*) const;
  void clearState();
    
private:
  void setTexture();
  
  //! Name of the texture file to show under the grid
  std::string filename;
  
  float size_x;
  float size_z;
  float altitude;
  float grid_unit;
  
  top10::util::Ref<top10::graphX::TransformNode> grid_transform;
  top10::util::Ref<top10::graphX::MaterialNode> grid_material;
  top10::util::Ref<top10::graphX::GridNode> grid_node;
  
  top10::util::Ref<top10::graphX::TransformNode> panel_transform;
  top10::util::Ref<top10::graphX::MaterialNode> panel_material;
  top10::util::Ref<top10::graphX::TextureNode> panel_texture;
  top10::util::Ref<top10::graphX::PanelNode> panel_node;
  
  unsigned char grid_r, grid_g, grid_b;
  unsigned char panel_r, panel_g, panel_b;
};

}
}

#endif
