/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_TRACKED_KERB_TEMPLATE_EDITOR_HH
#define TOP10_TRACKED_KERB_TEMPLATE_EDITOR_HH

#include "KerbTemplate.hh"
#include "util/XmlDumpable.hh"

#include <string>
#include <map>

namespace top10
{
namespace tracked
{

//! Editor for KerbTemplates.
class KerbTemplateEditor: public top10::util::XmlDumpable
{
public:
  KerbTemplateEditor();
  ~KerbTemplateEditor();

  // XmlDumpable
  void clearState();
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement*) const;

  void newKerb();
  void renameKerb(const std::string&);
  void gotoKerb(const std::string&);
  KerbTemplate getCurrent() const;
  void setWidthInner(double);
  void setWidthPlateau(double);
  void setWidthOuter(double);
  void setHeightInner(double);
  void setHeightOuter(double);

private:
  typedef std::map<std::string, KerbTemplate> KerbTemplates;
  KerbTemplates kerbs;
  KerbTemplates::iterator current;
};

}
}
#endif