/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_TRACKED_KERB_TEMPLATE_HH
#define TOP10_TRACKED_KERB_TEMPLATE_HH

#include "track/TextureSpec.hh"

namespace top10
{
namespace tracked
{

class KerbTemplateEditor;

//! Describes the properties of a type of kerbs
/*! KerbTemplates allow track designers to avoid re-entering the same properties for each kerb.
*/
class KerbTemplate: public top10::track::TextureSpec
{
public:
  KerbTemplate();
  ~KerbTemplate();

  // XmlDumpable
  void clearState();
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement*) const;

  double getWidthInner() const;
  double getWidthPlateau() const;
  double getWidthOuter() const;
  double getHeightInner() const;
  double getHeightOuter() const;

private:
  double width_inner;
  double width_plateau;
  double width_outer;
  double height_inner;
  double height_outer;

  //! Create and intialise instances using KerbTemplateEditor.
  friend class KerbTemplateEditor;
};

}
}
#endif