/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "KerbTemplate.hh"

namespace top10
{
namespace tracked
{

KerbTemplate::KerbTemplate():
top10::track::TextureSpec("kerb_template")
{
  clearState();
}

KerbTemplate::~KerbTemplate()
{
}

void KerbTemplate::clearState()
{
  width_inner = 0.3;
  width_plateau = 0.3;
  width_outer = 0.05;
  height_inner = 0.05;
  height_outer = 0.1;
}

int KerbTemplate::loadXml(const TiXmlElement* node)
{
  assert(node);
  int ret = 0;
  KerbTemplate tmp;

  ret = tmp.top10::track::TextureSpec::loadXml(node);

  int s = node->QueryDoubleAttribute("width_inner", &tmp.width_inner);
  if (s) {
    ret = s;
    logXmlNodeError("Missing width_inner attribute or wrong type", node, top10::util::Log::Warning);
  }

  s = node->QueryDoubleAttribute("width_plateau", &tmp.width_plateau);
  if (s) {
    ret = s;
    logXmlNodeError("Missing width_plateau attribute or wrong type", node, top10::util::Log::Warning);
  }

  s = node->QueryDoubleAttribute("width_outer", &tmp.width_outer);
  if (s) {
    ret = s;
    logXmlNodeError("Missing width_outer attribute or wrong type", node, top10::util::Log::Warning);
  }

  s = node->QueryDoubleAttribute("height_inner", &tmp.height_inner);
  if (s) {
    ret = s;
    logXmlNodeError("Missing height_inner attribute or wrong type", node, top10::util::Log::Warning);
  }

  s = node->QueryDoubleAttribute("height_outer", &tmp.height_outer);
  if (s) {
    ret = s;
    logXmlNodeError("Missing height_outer attribute or wrong type", node, top10::util::Log::Warning);
  }

  *this = tmp; // Ok, not completely exception-safe, std::string::operator= could throw, I guess...
  return ret;
}

int KerbTemplate::saveXml(TiXmlElement *node) const
{
  assert(node);
  int ret = 0;

  ret = top10::track::TextureSpec::saveXml(node);
  node->SetDoubleAttribute("width_inner", width_inner);
  node->SetDoubleAttribute("width_plateau", width_plateau);
  node->SetDoubleAttribute("width_outer", width_outer);
  node->SetDoubleAttribute("height_inner", height_inner);
  node->SetDoubleAttribute("height_outer", height_outer);

  return ret;
}

double KerbTemplate::getWidthInner() const
{
  return width_inner;
}

double KerbTemplate::getWidthPlateau() const
{
  return width_plateau;
}

double KerbTemplate::getWidthOuter() const
{
  return width_outer;
}

double KerbTemplate::getHeightInner() const
{
  return height_inner;
}

double KerbTemplate::getHeightOuter() const
{
  return height_outer;
}

}
}