/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_KERB_INSTANCE_EDITOR_H
#define TOP10_KERB_INSTANCE_EDITOR_H

#include "Drawable.hh"
#include "KerbInstance.hh"
#include "graphX/MaterialNode.hh"
#include <list>

namespace top10
{
  namespace tracked
  {

    class SectionsEditor;

    class KerbInstanceEditor: public Drawable
    {
    public:
      KerbInstanceEditor();
      ~KerbInstanceEditor();

      void setSectionsEditor(SectionsEditor*);

      // XmlDumpable
      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

      void addWaypoint(int id, int pos);
      void removeWaypointPos(int);
      void setAbsStart(double);
      void setAbsEnd(double);
      void setKerbTemplate(const std::string&);
      void newKerbInstance();
      
      void gotoPos(int);
      KerbInstance getCurrent() const;

    private:
      void updateView();
      void updateViewCurrent();
      top10::graphX::Node* makeNode(const KerbInstance&);

    private:
      SectionsEditor* sections_ed;
      std::list<KerbInstance> kerbs;
      std::list<KerbInstance>::iterator current;

      top10::util::Ref<top10::graphX::MaterialNode> dark;
      top10::util::Ref<top10::graphX::MaterialNode> bright;

    };

  }
}

#endif