/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_TRACKED_KERB_INSTANCE
#define TOP10_TRACKED_KERB_INSTANCE

#include "util/XmlDumpable.hh"
#include <vector>

namespace top10
{
  namespace tracked
  {

    class KerbInstance: public top10::util::XmlDumpable
    {
    public:
      enum Side {Left, Right};

    public:      
      KerbInstance();
      ~KerbInstance();

      // XmlDumpable
      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

      std::vector<int> getWaypointsIds() const;
      double getAbsStart() const;
      double getAbsEnd() const;
      Side getSide() const;

      void addWaypoint(int id, int pos);
      void removeWaypointPos(int);
      void setAbsStart(double);
      void setAbsEnd(double);
      void setType(const std::string&);

    private:
      std::string kerb_type;
      std::vector<int> wp_ids;
      double t_start;
      double t_end;
      Side side;
    };

  }
}
#endif