/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_TRACKEDHULLEDITOR_HH
#define TOP10_TRACKEDHULLEDITOR_HH

#include "Drawable.hh"
#include "PathEditor.hh"

namespace top10 {
namespace tracked {

class HullEditor: public Drawable
{
public:
  HullEditor();
  
  void setWaypointEditor(PathEditor*);
  
  // Implementation of Drawable
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement* node) const;
  void clearState();
  std::string getOrigin() const;
      
  // Manage the set of hulls
  void addHull();
  void removeHull();
  void renameHull(const std::string&);
  
  // Edit the current hull
  void addVertex();
  void removeVertex();
  void setCurrentVertex(int);
  void setInvert(bool);
  
  // Information used to populate dialogs
  std::string getCurrentHullName() const;
  std::vector<std::string> getHullNames() const;
  std::vector<std::string> getCurrentVertexNames() const;
  bool getInvert() const;
  int getCurrentVertexIdx() const;
  
private:
  typedef std::vector<int> Hull;
  struct NamedHull {
    std::string name;
    Hull hull;
    bool invert;
    
    int current_vertex;
  };
  
  PathEditor* waypoints_ed;
  std::list<NamedHull> hulls;
  std::list<NamedHull>::iterator current_hull;
  
  void loadNamedHull(const TiXmlElement*);
};

}
}

#endif
