/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Drawable.hh"
#include "util/strconv.hh"

using top10::util::Log;

namespace top10 {
namespace tracked {

Drawable::~Drawable()
{
  switch_node->clear();
}

void Drawable::addChild(top10::graphX::Node* node)
{
  switch_node->enable(0);
  switch_node->addChild(node);
  if (!visible) switch_node->enable(1);
}

void Drawable::removeChild(top10::graphX::Node* node)
{
  switch_node->enable(0);
  switch_node->removeChild(node);
  if (!visible) switch_node->enable(1);
}


}
}
