/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/


#ifndef TOP10_TRACKED_CHECKPOINTSEDITOR_HH
#define TOP10_TRACKED_CHECKPOINTSEDITOR_HH

#include "Drawable.hh"
#include "MainCamera.hh"
#include "racing/CheckPoint.hh"
#include <tinyxml.h>

namespace top10 {
  namespace tracked {
    class CheckpointsEditor: public Drawable {
    public:
      CheckpointsEditor();
   
      void clearState();

      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;
      
      inline std::string getOrigin() const { return "Checkpoints editor"; }
      
      inline void setCamera(MainCamera* p) { camera = p; }

      //! Use the current aimed point as the left point for the current checkpoint
      void pickLeft();
      void pickRight();
    
      //! Delete the current checkpoint
      void remove();

      //! Insert a checkpoint after the current checkpoint
      void addNew();

      //! Move to the next checkpoint
      void next();
      void previous();

      //! Return the current checkpoint
      top10::racing::CheckPoint getCurrent() const;

      inline int getCurrentIndex() const { return current_cp; }
      
    public:
      top10::racing::CheckPoints checkpoints;

    private:
      class Node: public top10::graphX::LeafNode {
      public:
        Node(CheckpointsEditor* ed): ed(ed) {}
        void renderGL(const top10::graphX::RenderingFeatures&, const top10::graphX::RenderState&, const top10::graphX::CameraNode&) const;    
      private:
        CheckpointsEditor* ed;
      };
      
      top10::util::Ref<Node> top_node;
      int current_cp;
      MainCamera* camera;

      bool isCorrect(int current_cp) const;
      friend class Node;
    };
  };
};
#endif

